clear;clc
% Temperature Isotherm 
test = 1;
while any(test) % Test numerical input
    prompt = {'Temperature Isotherm (Delta Temperature)'};
    dlg_title = 'Temperature Isotherm';
    num_lines = 1;
    def     = {'1.0'};
    isoth  = inputdlg(prompt,dlg_title,num_lines,def);
    dT = str2num(isoth{1}); dTTrue = isempty(dT); 
    test = [dTTrue];
end

% Input flow and heat transport parameters
test = 1;
while any(test) % Test numerical input
    prompt = {'Heat flux [W/m]','Vol. heat capacity of water [J m-3 K-1]',...
        'thermal conductivity of aquifer [W m-1 K-1]','longitudinal dispersivity [m]:','transversal dispersivity [m]:',...
        'Specific flux (Darcy flux) [m s-1]:'};
    dlg_title = 'Transportparameter';
    num_lines = 1;
    def     = {'50.0','4.2E6','2.5','0.0','0.0','2.25E-6'};
    transportparameter  = inputdlg(prompt,dlg_title,num_lines,def);
    QL = str2num(transportparameter{1}); QLTrue = isempty(QL); 
    Cw = str2num(transportparameter{2}); CwTrue = isempty(Cw);
    lm = str2num(transportparameter{3}); lmTrue = isempty(lm);
    ax = str2num(transportparameter{4}); axTrue = isempty(ax);
    ay = str2num(transportparameter{5}); ayTrue = isempty(ay);
    q = str2num(transportparameter{6}); qTrue = isempty(q);
    test = [QLTrue; CwTrue; lmTrue; axTrue; ayTrue; qTrue];
end


%% Analiytical solution 
PlumeLength = (QL^2/8/pi/dT^2/Cw/q/(lm+ay*q*Cw))*...
    (1+sqrt(1-(8*pi*dT^2*(lm+ax*q*Cw)*(lm+ay*q*Cw)/QL^2)));
u = Cw*q*PlumeLength/2/(lm+ax*q*Cw);

%% Output
fprintf('Plume length = %0.2f m \n',PlumeLength)
fprintf('u = %0.2f \n',u)

